//general stuff
#include "../slim.h"

#include "../parse/scene_parser.h"
#include "./parse_args.h"
#include "./read_scene.h"
//#include "./load_mods.h"
#include "load.h"
#include "./setup_scene.h"
#include "../common/objects.h"
#include "../common/structs.h"
#include "../common/debug.h"
#include <string.h>
#include <stdlib.h>

int init_scene(int argc, char** argv, scene_data* main_scene)
{
	char path[255];
	
	/* load mods in default dir */

	/* parse the arguemnts */
	printd(2, "parsing the args\n");
	get_scene_path(argc, argv, (char*)&path);
	
	load_scene(path, main_scene);

	return 1;
}

void clean_scene(scene_data *scene)
{
	int i;

	for(i=0; scene->models[i]!=NULL;i++)
	{
		free(scene->models[i]);
		scene->models[i] = NULL;
	}

	for(i=0; scene->lights[i]!=NULL;i++)
	{
		free(scene->lights[i]);
		scene->lights[i] = NULL;
	}
	  
	free(scene->frame_buffer);
	free(scene->back_buffer);
	free(scene->misc_buffer);
	free(scene->intersect_buffer);
}

int load_scene(char *path, scene_data *main_scene)
{
	char error = 0;

	strncpy(main_scene->name, path, NAME_LENGTH);
	
	clean_scene(main_scene);

	// load the file into memory
	printd(2, "reading scene\n");
	if(read_scene(main_scene) == 1)
	{
		printd(2, "parsing scene\n");
		if( parse_scene(main_scene) == 0)
			error = 1;
	}
	else
		error = 1;

	// this does any pre-render calcs
	printd(2, "setting up scene\n");
	if( setup_scene(main_scene) == 0)
		error = 1;

	if(error)
		return 0;

	return 1;
}
